/*
 * Decompiled with CFR 0.152.
 */
package TCPIP_Discoverer;

import TCPIP_Discoverer.TCPIPAboutBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TcpIpDiscoverTool
extends JFrame {
    private JTree tree;
    private JScrollPane scrollPane;
    private DatagramSocket socket;
    private DatagramPacket packet;
    private Thread recvThread = null;
    private String mchipUrl;
    TCPIPAboutBox aboutBox;
    String discvStr = new String("Discovery: Who is out there?\u0000\n");
    String received = " ";
    long threadSleep = 500L;
    ReentrantLock lock = new ReentrantLock();
    ImageIcon icon = new ImageIcon(this.getClass().getResource("/Resource/mchpIcon.png"));
    DefaultMutableTreeNode root;
    DefaultMutableTreeNode harmonyNode;
    DefaultMutableTreeNode mlaNode;
    DefaultTreeModel model;
    short gSegFlag = 0;
    int clickCnt = 0;
    static String[] OUI_Microchip_byte = new String[]{"00-04-A3", "00-1E-C0", "D8-80-39", "54-10-EC", "FC-C2-3D", "00-04-25"};
    ANNOUNCE_SOCKET_BCAST_TYPE annce_bcast_type;
    private JButton btnDiscover;
    private JButton btnExit;
    private JCheckBox jCheckBox1;
    private JPanel jPanel1;
    private JLabel lebelAbout;

    public TcpIpDiscoverTool() {
        this.initComponents();
        this.aboutBox = new TCPIPAboutBox((Frame)this, true);
        this.jPanel1.setSize(800, 400);
        this.setIconImage(this.icon.getImage());
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        String aboutStr = "<html>Date   - June,22 2017<br>";
        String version = "Version - TCPIP Discoverer 2.5";
        this.lebelAbout.setText(aboutStr + version + "</html>");
        this.root = new DefaultMutableTreeNode("Microchip Devices");
        this.model = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.root);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.tree);
        this.jPanel1.setLayout(new BorderLayout());
        this.udpAction();
        this.jPanel1.add((Component)this.scrollPane, "Center");
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TcpIpDiscoverTool.this.treeMouseClicked(evt);
            }
        });
        this.pack();
    }

    void treeMouseClicked(MouseEvent evt) {
        this.clickCnt += evt.getClickCount();
        if (this.clickCnt == 2) {
            DefaultMutableTreeNode parentNode = null;
            DefaultMutableTreeNode ipNode = null;
            TreePath parentPath = this.tree.getSelectionPath();
            if (parentPath == null) {
                return;
            }
            parentNode = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
            String MacAddress = parentNode.toString();
            if (!MacAddress.startsWith("MAC-Address")) {
                return;
            }
            if (parentNode != null && (ipNode = this.findNode("IP Addresses", parentNode)) != null) {
                DefaultMutableTreeNode ipAddress = (DefaultMutableTreeNode)ipNode.getChildAt(0);
                String ipv4Str = ipAddress.toString();
                this.mchipUrl = "http://" + ipv4Str;
                try {
                    URL myUrl = new URL(this.mchipUrl);
                    Desktop.getDesktop().browse(myUrl.toURI());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        this.clickCnt = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void receiveUDPPacket() {
        try {
            buf = new byte[1472];
            for (i = 0; i < buf.length; ++i) {
                buf[i] = 32;
            }
            this.packet = new DatagramPacket(buf, buf.length);
            this.socket.receive(this.packet);
            this.received = new String(this.packet.getData());
            while (true) lbl-1000:
            // 5 sources

            {
                for (i = 0; i < buf.length; ++i) {
                    buf[i] = 32;
                }
                this.packet = new DatagramPacket(buf, buf.length);
                try {
                    this.socket.receive(this.packet);
                }
                catch (SocketTimeoutException var2_4) {
                    // empty catch block
                }
                if (new String(this.packet.getData()).trim().length() == 0 || this.packet.getLength() < 35) ** continue;
                this.lock.lock();
                try {
                    this.addDiscoveryEntry(this.packet);
                    this.received = " ";
                    this.model.reload();
                    this.jPanel1.revalidate();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            TcpIpDiscoverTool.this.tree.updateUI();
                            for (int i = 0; i < TcpIpDiscoverTool.this.tree.getRowCount(); ++i) {
                                TcpIpDiscoverTool.this.tree.expandRow(i);
                            }
                        }
                    });
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.close_action();
            return;
        }
        ** GOTO lbl-1000
    }

    public void udpAction() {
        try {
            this.recvThread = new Thread(){

                public void run() {
                    TcpIpDiscoverTool.this.receiveUDPPacket();
                }
            };
            this.socket = new DatagramSocket(30303);
            this.socket.setBroadcast(true);
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            int mask = 0;
            byte[] result = new byte[4];
            byte[] netmask = new byte[4];
            if (this.annce_bcast_type == ANNOUNCE_SOCKET_BCAST_TYPE.ANNOUNCE_UDP_BCAST_NETWORK_DIRECTED) {
                for (NetworkInterface iface : interfaces) {
                    if (!iface.isUp()) continue;
                    for (InterfaceAddress addr : iface.getInterfaceAddresses()) {
                        InetAddress i = addr.getAddress();
                        if (i.isLinkLocalAddress() || i.isLoopbackAddress()) continue;
                        byte[] ipAddrs = i.getAddress();
                        if (addr.getNetworkPrefixLength() == -1) continue;
                        mask = -1 << 32 - addr.getNetworkPrefixLength();
                        netmask[0] = (byte)(mask >> 24);
                        netmask[1] = (byte)(mask >> 16);
                        netmask[2] = (byte)(mask >> 8);
                        netmask[3] = (byte)mask;
                        result[0] = (byte)(ipAddrs[0] | ~netmask[0]);
                        result[1] = (byte)(ipAddrs[1] | ~netmask[1]);
                        result[2] = (byte)(ipAddrs[2] | ~netmask[2]);
                        result[3] = (byte)(ipAddrs[3] | ~netmask[3]);
                        InetAddress ipAddr2 = InetAddress.getByAddress(result);
                        this.packet = new DatagramPacket(this.discvStr.getBytes(), this.discvStr.length(), ipAddr2, 30303);
                        this.socket.send(this.packet);
                    }
                }
            } else {
                InetAddress bcast_address = InetAddress.getByName("255.255.255.255");
                this.packet = new DatagramPacket(this.discvStr.getBytes(), this.discvStr.length(), bcast_address, 30303);
                this.socket.send(this.packet);
            }
            this.recvThread.start();
        }
        catch (IOException e) {
            String optionStr = "<html>Unable to transmit discovery message. <br> Check network connectivity and ensure that no other instances of this program are running.";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
            System.exit(0);
        }
    }

    public void close_action() {
        if (this.socket != null && this.socket.isConnected()) {
            this.socket.close();
        }
        if (this.recvThread != null && this.recvThread.isAlive()) {
            this.recvThread = null;
        }
    }

    public void addDiscoveryEntry(DatagramPacket receivedPacket) {
        byte[] paktBuf = receivedPacket.getData();
        int packetLen = receivedPacket.getLength();
        int dataCnt = 0;
        String macAddress = "MAC-Address - ";
        String macType = "MAC-Type";
        String hostName = "Hostname";
        String ipAddr = "IP Addresses";
        String multicastAddr = "Multicast Listeners";
        String defaultRouter = "Default Router";
        String defaultGateway = "Default Gateway";
        String harmonyNodeName = "Harmony";
        String message = "User Data";
        int i = 0;
        DefaultMutableTreeNode macNode = null;
        DefaultMutableTreeNode multicastListenerNode = null;
        DefaultMutableTreeNode ipNode = null;
        DefaultMutableTreeNode messageNode = null;
        DefaultMutableTreeNode macTypeNode = null;
        DefaultMutableTreeNode netBiosNode = null;
        byte[] multicastListener = new byte[]{-1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1};
        dataCnt = 0;
        while (dataCnt < packetLen) {
            byte[] temp;
            switch (paktBuf[dataCnt]) {
                case 1: {
                    this.insertNode("Truncated", macNode, macNode.getChildCount());
                    return;
                }
                case 2: {
                    temp = new byte[6];
                    ++dataCnt;
                    for (i = 0; i < 6; ++i) {
                        temp[i] = paktBuf[dataCnt++];
                    }
                    if (temp.length == 0) break;
                    this.harmonyNode = this.findNode(harmonyNodeName, this.root);
                    if (this.harmonyNode == null) {
                        this.insertNode(harmonyNodeName, this.root, this.root.getChildCount());
                        this.harmonyNode = this.findNode(harmonyNodeName, this.root);
                    }
                    StringBuilder sb = new StringBuilder(22);
                    for (byte b : temp) {
                        if (sb.length() > 0) {
                            sb.append(':');
                        }
                        sb.append(String.format("%02x", b));
                    }
                    macNode = this.findNode(macAddress = macAddress.concat(sb.toString()), this.harmonyNode);
                    if (macNode != null) break;
                    this.insertNode(macAddress, this.harmonyNode, this.harmonyNode.getChildCount());
                    macNode = this.findNode(macAddress, this.harmonyNode);
                    break;
                }
                case 3: {
                    if (macNode == null || this.harmonyNode == null) break;
                    ++dataCnt;
                    temp = new byte[16];
                    i = 0;
                    while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10) {
                        temp[i++] = paktBuf[dataCnt++];
                    }
                    temp[i] = 10;
                    String byteToStr = new String(temp);
                    byteToStr = byteToStr.substring(0, i);
                    macTypeNode = this.findNode(macType, macNode);
                    if (macTypeNode == null) {
                        this.insertNode(macType, macNode, macNode.getChildCount());
                        macTypeNode = this.findNode(macType, macNode);
                    }
                    if (this.findNode(byteToStr, macTypeNode) != null) break;
                    this.insertNode(byteToStr, macTypeNode, macTypeNode.getChildCount());
                    break;
                }
                case 4: {
                    if (macNode == null || this.harmonyNode == null) break;
                    ++dataCnt;
                    temp = new byte[16];
                    i = 0;
                    while (paktBuf[dataCnt] != 13 && paktBuf[dataCnt + 1] != 10) {
                        temp[i++] = paktBuf[dataCnt++];
                    }
                    String byteToStr = new String(temp);
                    byteToStr = byteToStr.substring(0, i);
                    netBiosNode = this.findNode(hostName, macNode);
                    if (netBiosNode == null) {
                        this.insertNode(hostName, macNode, macNode.getChildCount());
                        netBiosNode = this.findNode(hostName, macNode);
                    }
                    if (this.findNode(byteToStr, netBiosNode) != null) break;
                    this.insertNode(byteToStr, netBiosNode, netBiosNode.getChildCount());
                    break;
                }
                case 5: {
                    if (macNode == null || this.harmonyNode == null) break;
                    temp = new byte[4];
                    ++dataCnt;
                    i = 0;
                    while (i < 4) {
                        temp[i++] = paktBuf[dataCnt++];
                    }
                    if (temp.length == 0) break;
                    StringBuilder sb = new StringBuilder(22);
                    for (byte b : temp) {
                        if (sb.length() > 0) {
                            sb.append('.');
                        }
                        sb.append(String.format("%d", (short)(b & 0xFF)));
                    }
                    ipNode = this.findNode(ipAddr, macNode);
                    if (ipNode == null) {
                        this.insertNode(ipAddr, macNode, macNode.getChildCount());
                        ipNode = this.findNode(ipAddr, macNode);
                    }
                    if (this.findNode(sb.toString(), ipNode) != null) break;
                    this.insertNode(sb.toString(), ipNode, ipNode.getChildCount());
                    break;
                }
                case 6: {
                    if (macNode == null || this.harmonyNode == null) break;
                    temp = new byte[16];
                    ++dataCnt;
                    i = 0;
                    while (i < 16) {
                        temp[i++] = paktBuf[dataCnt++];
                    }
                    if (temp.length == 0) break;
                    String ipv6AddressStr = TcpIpDiscoverTool.ipv6NumericToTextFormat(temp);
                    ipNode = this.findNode(ipAddr, macNode);
                    if (ipNode == null) {
                        this.insertNode(ipAddr, macNode, macNode.getChildCount());
                        ipNode = this.findNode(ipAddr, macNode);
                    }
                    if (this.findNode(ipv6AddressStr, ipNode) != null) break;
                    this.insertNode(ipv6AddressStr, ipNode, ipNode.getChildCount());
                    for (i = 0; i < multicastListener.length; ++i) {
                        temp[i] = multicastListener[i];
                    }
                    ipv6AddressStr = TcpIpDiscoverTool.ipv6NumericToTextFormat(temp);
                    multicastListenerNode = this.findNode(multicastAddr, macNode);
                    if (multicastListenerNode == null) {
                        this.insertNode(multicastAddr, macNode, macNode.getChildCount());
                        multicastListenerNode = this.findNode(multicastAddr, macNode);
                    }
                    if (this.findNode(ipv6AddressStr, multicastListenerNode) != null) break;
                    this.insertNode(ipv6AddressStr, multicastListenerNode, multicastListenerNode.getChildCount());
                    break;
                }
                case 7: {
                    if (macNode == null || this.harmonyNode == null) break;
                    temp = new byte[16];
                    ++dataCnt;
                    i = 0;
                    while (i < 16) {
                        temp[i++] = paktBuf[dataCnt++];
                    }
                    if (temp.length == 0) break;
                    String ipv6AddressStr = TcpIpDiscoverTool.ipv6NumericToTextFormat(temp);
                    multicastListenerNode = this.findNode(multicastAddr, macNode);
                    if (multicastListenerNode == null) {
                        this.insertNode(multicastAddr, macNode, macNode.getChildCount());
                        multicastListenerNode = this.findNode(multicastAddr, macNode);
                    }
                    if (this.findNode(ipv6AddressStr, multicastListenerNode) != null) break;
                    this.insertNode(ipv6AddressStr, multicastListenerNode, multicastListenerNode.getChildCount());
                    break;
                }
                case 8: {
                    if (macNode == null || this.harmonyNode == null) break;
                    temp = new byte[16];
                    ++dataCnt;
                    i = 0;
                    while (i < 16) {
                        temp[i++] = paktBuf[dataCnt++];
                    }
                    if (temp.length == 0) break;
                    String ipv6AddressStr = TcpIpDiscoverTool.ipv6NumericToTextFormat(temp);
                    ipNode = this.findNode(defaultRouter, macNode);
                    if (ipNode == null) {
                        this.insertNode(defaultRouter, macNode, macNode.getChildCount());
                        ipNode = this.findNode(defaultRouter, macNode);
                    }
                    if (this.findNode(ipv6AddressStr, ipNode) != null) break;
                    this.insertNode(ipv6AddressStr, ipNode, ipNode.getChildCount());
                    for (i = 0; i < multicastListener.length; ++i) {
                        temp[i] = multicastListener[i];
                    }
                    ipv6AddressStr = TcpIpDiscoverTool.ipv6NumericToTextFormat(temp);
                    multicastListenerNode = this.findNode(multicastAddr, macNode);
                    if (multicastListenerNode == null) {
                        this.insertNode(multicastAddr, macNode, macNode.getChildCount());
                        multicastListenerNode = this.findNode(multicastAddr, macNode);
                    }
                    if (this.findNode(ipv6AddressStr, multicastListenerNode) != null) break;
                    this.insertNode(ipv6AddressStr, multicastListenerNode, multicastListenerNode.getChildCount());
                    break;
                }
                case 9: {
                    if (macNode == null || this.harmonyNode == null) break;
                    temp = new byte[16];
                    ++dataCnt;
                    i = 0;
                    while (i < 16) {
                        temp[i++] = paktBuf[dataCnt++];
                    }
                    if (temp.length == 0) break;
                    String ipv6AddressStr = TcpIpDiscoverTool.ipv6NumericToTextFormat(temp);
                    ipNode = this.findNode(defaultGateway, macNode);
                    if (ipNode == null) {
                        this.insertNode(defaultGateway, macNode, macNode.getChildCount());
                        ipNode = this.findNode(defaultGateway, macNode);
                    }
                    if (this.findNode(ipv6AddressStr, ipNode) != null) break;
                    this.insertNode(ipv6AddressStr, ipNode, ipNode.getChildCount());
                    break;
                }
                default: {
                    this.addEntryForMLAAnnoucePacket(receivedPacket);
                    return;
                }
            }
            if (paktBuf[dataCnt] == 13) {
                ++dataCnt;
            }
            if (paktBuf[dataCnt] == 10) {
                ++dataCnt;
            }
            if (paktBuf[dataCnt] != 13 || paktBuf[dataCnt + 1] != 10) continue;
            messageNode = this.findNode(message, macNode);
            if (messageNode == null) {
                this.insertNode(message, macNode, macNode.getChildCount());
                messageNode = this.findNode(message, macNode);
            }
            dataCnt += 2;
            temp = new byte[100];
            i = 0;
            while (dataCnt < packetLen) {
                temp[i++] = paktBuf[dataCnt++];
                if (i != 100) continue;
            }
            try {
                String msgBuf = new String(temp, "UTF-8");
                if (this.findNode(msgBuf, messageNode) != null) continue;
                this.insertNode(msgBuf, messageNode, messageNode.getChildCount());
            }
            catch (UnsupportedEncodingException e) {}
        }
    }

    public boolean addEntryForMLAAnnoucePacket(DatagramPacket receivedPacket) {
        int i;
        String packetString = new String(receivedPacket.getData());
        String[] packetBuf = packetString.split("\r\n");
        InetAddress ipAddres = receivedPacket.getAddress();
        String ipAddrStr = ipAddres.toString();
        DefaultMutableTreeNode macNode = null;
        DefaultMutableTreeNode ipNode = null;
        DefaultMutableTreeNode messageNode = null;
        String mlaNodeName = "Microchip Legacy Library";
        String macAddress = "MAC-Address - ";
        String hostName = "Hostname - ";
        String ipAddr = "IP Addresses";
        String message = "Message";
        if (ipAddrStr.isEmpty()) {
            return false;
        }
        ipAddrStr = ipAddrStr.replace("/", "");
        if (packetBuf[0].isEmpty()) {
            return false;
        }
        hostName = hostName.concat(packetBuf[0]);
        if (packetBuf[1].isEmpty()) {
            return false;
        }
        for (i = 0; i < OUI_Microchip_byte.length && !packetBuf[1].contains(OUI_Microchip_byte[i]); ++i) {
        }
        if (i > OUI_Microchip_byte.length) {
            return false;
        }
        this.mlaNode = this.findNode(mlaNodeName, this.root);
        if (this.mlaNode == null) {
            this.insertNode(mlaNodeName, this.mlaNode, this.root.getChildCount());
            this.mlaNode = this.findNode(mlaNodeName, this.root);
        }
        if ((macNode = this.findNode(macAddress = macAddress.concat(packetBuf[1]), this.mlaNode)) != null) {
            this.removeNodeFromRoot(macNode);
        }
        this.insertNode(macAddress, this.mlaNode, this.mlaNode.getChildCount());
        macNode = this.findNode(macAddress, this.mlaNode);
        if (this.findNode(hostName, macNode) == null) {
            this.insertNode(hostName, macNode, macNode.getChildCount());
        }
        if ((ipNode = this.findNode(ipAddr, macNode)) == null) {
            this.insertNode(ipAddr, macNode, macNode.getChildCount());
            ipNode = this.findNode(ipAddr, macNode);
        }
        if (this.findNode(ipAddrStr, ipNode) == null) {
            this.insertNode(ipAddrStr, ipNode, ipNode.getChildCount());
        }
        if (packetBuf[2].length() != 0 && packetBuf[2].contains("DHCP")) {
            messageNode = this.findNode(message, macNode);
            if (messageNode == null) {
                this.insertNode(message, macNode, macNode.getChildCount());
                messageNode = this.findNode(message, macNode);
            }
            if (this.findNode(packetBuf[2], messageNode) == null) {
                this.insertNode(packetBuf[2], messageNode, messageNode.getChildCount());
            }
        }
        return true;
    }

    static String ipv6NumericToTextFormat(byte[] src) {
        StringBuffer sb = new StringBuffer(39);
        for (int i = 0; i < 8; ++i) {
            sb.append(Integer.toHexString(src[i << 1] << 8 & 0xFF00 | src[(i << 1) + 1] & 0xFF));
            if (i >= 7) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    private void initComponents() {
        this.btnDiscover = new JButton();
        this.btnExit = new JButton();
        this.jPanel1 = new JPanel();
        this.lebelAbout = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("Microchip TCPIP Discoverer");
        this.setResizable(false);
        this.btnDiscover.setText("Discover Devices");
        this.btnDiscover.setCursor(new Cursor(0));
        this.btnDiscover.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TcpIpDiscoverTool.this.btnDiscoverActionPerformed(evt);
            }
        });
        this.btnExit.setText("Exit");
        this.btnExit.setMaximumSize(new Dimension(115, 23));
        this.btnExit.setMinimumSize(new Dimension(115, 23));
        this.btnExit.setPreferredSize(new Dimension(115, 23));
        this.btnExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TcpIpDiscoverTool.this.btnExitActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setMinimumSize(new Dimension(600, 800));
        this.jPanel1.setPreferredSize(new Dimension(651, 800));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 648, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.lebelAbout.setBackground(new Color(153, 153, 153));
        this.lebelAbout.setFont(new Font("Microsoft Sans Serif", 1, 11));
        this.lebelAbout.setForeground(new Color(0, 0, 204));
        this.lebelAbout.setText("<html> date <br> version </html>");
        this.lebelAbout.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.lebelAbout.setCursor(new Cursor(12));
        this.lebelAbout.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TcpIpDiscoverTool.this.lebelAboutMouseClicked(evt);
            }
        });
        this.jCheckBox1.setText("Network Direct Broadcast");
        this.jCheckBox1.setToolTipText("<html>On for Direct Broadcast (e.g: x.x.x.255)<br> Off for Limited broadcast (e.g: 255.255.255.255)");
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TcpIpDiscoverTool.this.jCheckBox1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(64, 64, 64).addComponent(this.btnDiscover, -2, 158, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBox1).addGap(72, 72, 72).addComponent(this.btnExit, -2, 150, -2).addGap(46, 46, 46)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 652, -2)).addGroup(layout.createSequentialGroup().addGap(403, 403, 403).addComponent(this.lebelAbout, -2, 236, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnDiscover, -2, 28, -2).addComponent(this.btnExit, -2, 28, -2).addComponent(this.jCheckBox1)).addGap(18, 18, 18).addComponent(this.jPanel1, -2, 336, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lebelAbout, -2, 37, -2).addContainerGap()));
        this.pack();
    }

    private void btnDiscoverActionPerformed(ActionEvent evt) {
        try {
            if (!this.socket.isBound()) {
                this.socket = new DatagramSocket(30303);
                System.out.println("EthDiscoverActionPerformed:after socket");
            }
            this.removeAllNode();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TcpIpDiscoverTool.this.tree.updateUI();
                }
            });
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            int mask = 0;
            byte[] result = new byte[4];
            byte[] netmask = new byte[4];
            if (this.annce_bcast_type == ANNOUNCE_SOCKET_BCAST_TYPE.ANNOUNCE_UDP_BCAST_NETWORK_DIRECTED) {
                for (NetworkInterface iface : interfaces) {
                    if (!iface.isUp()) continue;
                    for (InterfaceAddress addr : iface.getInterfaceAddresses()) {
                        InetAddress i = addr.getAddress();
                        if (i.isLinkLocalAddress() || i.isLoopbackAddress()) continue;
                        byte[] ipAddrs = i.getAddress();
                        if (addr.getNetworkPrefixLength() == -1) continue;
                        mask = -1 << 32 - addr.getNetworkPrefixLength();
                        netmask[0] = (byte)(mask >> 24);
                        netmask[1] = (byte)(mask >> 16);
                        netmask[2] = (byte)(mask >> 8);
                        netmask[3] = (byte)mask;
                        result[0] = (byte)(ipAddrs[0] | ~netmask[0]);
                        result[1] = (byte)(ipAddrs[1] | ~netmask[1]);
                        result[2] = (byte)(ipAddrs[2] | ~netmask[2]);
                        result[3] = (byte)(ipAddrs[3] | ~netmask[3]);
                        InetAddress ipAddr2 = InetAddress.getByAddress(result);
                        this.packet = new DatagramPacket(this.discvStr.getBytes(), this.discvStr.length(), ipAddr2, 30303);
                        this.socket.send(this.packet);
                    }
                }
            } else {
                InetAddress bcast_address = InetAddress.getByName("255.255.255.255");
                this.packet = new DatagramPacket(this.discvStr.getBytes(), this.discvStr.length(), bcast_address, 30303);
                this.socket.send(this.packet);
            }
        }
        catch (IOException soEx) {
            String optionStr = "<html>Unable to transmit discovery message. <br> Check network connectivity and ensure that no other instances of this program are running.";
            JOptionPane.showMessageDialog(null, optionStr, "Error", 0);
            this.close_action();
            System.exit(0);
        }
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void lebelAboutMouseClicked(MouseEvent evt) {
        this.aboutBox.setVisible(true);
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.annce_bcast_type = this.jCheckBox1.isSelected() ? ANNOUNCE_SOCKET_BCAST_TYPE.ANNOUNCE_UDP_BCAST_NETWORK_DIRECTED : ANNOUNCE_SOCKET_BCAST_TYPE.ANNOUNCE_UDP_BCAST_NETWORK_LIMITED;
    }

    private DefaultMutableTreeNode findNode(String s, DefaultMutableTreeNode node) {
        Enumeration<TreeNode> e = node.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            if (node.toString().equals(s)) {
                return node;
            }
            if (!node.toString().startsWith(s)) continue;
            return node;
        }
        return null;
    }

    private void insertNode(String s, DefaultMutableTreeNode node, int pos) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(s);
        if (node == null) {
            node = new DefaultMutableTreeNode(s);
            this.model.insertNodeInto(node, this.root, this.root.getChildCount());
        } else {
            this.model.insertNodeInto(child, node, pos);
        }
    }

    private void removeAllNode() {
        boolean i = false;
        while (!this.root.isLeaf()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getFirstChild();
            this.model.removeNodeFromParent(node);
        }
        this.root.removeAllChildren();
        this.model.reload();
    }

    private void removeNodeFromRoot(DefaultMutableTreeNode node) {
        this.model.removeNodeFromParent(node);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new TcpIpDiscoverTool().setVisible(true);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ANNOUNCE_SOCKET_BCAST_TYPE {
        ANNOUNCE_UDP_BCAST_NONE,
        ANNOUNCE_UDP_BCAST_NETWORK_LIMITED,
        ANNOUNCE_UDP_BCAST_NETWORK_DIRECTED;

    }
}

